/*
 * Decompiled with CFR 0.152.
 */
package com.marinilli.b2.c11.util;

import com.marinilli.b2.c11.util.Utilities;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JNLPLabel
extends JLabel
implements MouseListener {
    private String text = "";
    private URL url = null;
    private static final String COLOR_BEFORE_CLICKING = "blue";
    private static final String COLOR_AFTER_CLICKING = "purple";
    private boolean alreadyClicked = false;
    private transient Vector hListeners;

    public JNLPLabel() {
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        this.alreadyClicked = true;
        Toolkit.getDefaultToolkit().beep();
        this.fireHyperlinkUpdate(new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, this.url));
        Utilities.getBasicService().showDocument(this.url);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.alreadyClicked) {
            super.setText(String.valueOf(String.valueOf(new StringBuffer("<html><font color=blue ><u>").append(this.text).append("</u></font>"))));
        } else {
            super.setText(String.valueOf(String.valueOf(new StringBuffer("<html><font color=purple ><u>").append(this.text).append("</u></font>"))));
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent e) {
        this.setText(String.valueOf(String.valueOf(new StringBuffer("<html><body>").append(this.text).append(""))));
    }

    public void setText(String txt) {
        this.text = txt;
        super.setText(String.valueOf(String.valueOf(new StringBuffer("<html><font color=blue ><u>").append(this.text).append("</u></font>"))));
    }

    public void setURL(URL u) {
        this.url = u;
        this.setToolTipText("view in browser ".concat(String.valueOf(String.valueOf(this.url))));
    }

    public void setURL(String u) {
        try {
            this.setURL(new URL(u));
        }
        catch (Exception exc) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass()))).append("setURL: ").append(exc))));
        }
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener l) {
        if (this.hListeners != null && this.hListeners.contains(l)) {
            Vector v = (Vector)this.hListeners.clone();
            v.removeElement(l);
            this.hListeners = v;
        }
    }

    public synchronized void addHyperlinkListener(HyperlinkListener l) {
        Vector v = this.hListeners == null ? new Vector(2) : (Vector)this.hListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.hListeners = v;
        }
    }

    protected void fireHyperlinkUpdate(HyperlinkEvent e) {
        if (this.hListeners != null) {
            Vector listeners = this.hListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((HyperlinkListener)listeners.elementAt(i)).hyperlinkUpdate(e);
            }
        }
    }

    static {
        COLOR_BEFORE_CLICKING = COLOR_BEFORE_CLICKING;
        COLOR_AFTER_CLICKING = COLOR_AFTER_CLICKING;
    }
}

