/*
 * Decompiled with CFR 0.152.
 */
package com.marinilli.b2.c11.util;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.ImageIcon;

public class Utilities {
    private static Utilities util;
    private static ClassLoader loader;
    private static BasicService basicService;
    private static ImageIcon EMPTY_ICON;
    private ResourceBundle msg;
    private static String bundleFilename;

    static {
        EMPTY_ICON = new ImageIcon(new BufferedImage(24, 24, 1));
        bundleFilename = "messages";
    }

    private Utilities() {
        loader = this.getClass().getClassLoader();
        basicService = (BasicService)Utilities.getService("javax.jnlp.BasicService");
        this.initializeDefaultResources();
        try {
            this.msg = ResourceBundle.getBundle(bundleFilename);
        }
        catch (MissingResourceException mre) {
            this.msg = null;
        }
    }

    private void initializeDefaultResources() {
        Graphics g = EMPTY_ICON.getImage().getGraphics();
        g.drawLine(8, 8, 16, 16);
        g.drawLine(8, 16, 16, 8);
    }

    public static ClassLoader getClassLoader() {
        if (util == null) {
            Utilities.getInstance();
        }
        return loader;
    }

    public static ImageIcon getImageIcon(String name) {
        URL res;
        if (util == null) {
            Utilities.getInstance();
        }
        if ((res = loader.getResource(name)) != null) {
            return new ImageIcon(res);
        }
        return EMPTY_ICON;
    }

    public static Object getService(String fullyQName) {
        Object service = null;
        try {
            service = ServiceManager.lookup((String)fullyQName);
        }
        catch (UnavailableServiceException use) {
            System.out.println(util.getClass() + "getService(" + fullyQName + ") " + (Object)((Object)use));
        }
        return service;
    }

    public static BasicService getBasicService() {
        if (util == null) {
            Utilities.getInstance();
        }
        return basicService;
    }

    public static String getMsg(String key) {
        String m;
        if (util == null) {
            Utilities.getInstance();
        }
        if (Utilities.util.msg != null && (m = Utilities.util.msg.getString(key)) != null) {
            return m;
        }
        return "";
    }

    public static Utilities getInstance() {
        if (util == null) {
            util = new Utilities();
        }
        return util;
    }

    public static Utilities getInstance(String resourceBundleName) {
        bundleFilename = resourceBundleName;
        if (util == null) {
            Utilities.getInstance();
        } else {
            System.out.println(util.getClass() + " getInstance must be invoked as initializator.");
        }
        return util;
    }
}

