/*
 * Decompiled with CFR 0.152.
 */
package com.marinilli.b2.c11.util;

import com.marinilli.b2.c11.util.Utilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public class PersistentStorage {
    private PersistenceService persistenceService;
    private long DEFAULT_SIZE = 2048L;

    public PersistentStorage() {
        this.persistenceService = (PersistenceService)Utilities.getService("javax.jnlp.PersistenceService");
    }

    public PersistentStorage(PersistenceService ps) {
        this.persistenceService = ps;
    }

    public void write(String keyString, Object value) {
        this.write(keyString, value, this.DEFAULT_SIZE);
    }

    public void write(String keyString, Object value, long maxLength) {
        this.write(this.getUrl(keyString), value, this.DEFAULT_SIZE);
    }

    public void write(URL url, Object value, long maxLength) {
        if (this.exists(url)) {
            this.removeEntry(url);
        }
        try {
            this.persistenceService.create(url, maxLength);
            FileContents fc = this.persistenceService.get(url);
            ObjectOutputStream oos = new ObjectOutputStream(fc.getOutputStream(false));
            oos.writeObject(value);
            oos.close();
        }
        catch (IOException ioe) {
            System.out.println(this.getClass() + ".write(" + url + ", " + value + "): " + ioe);
        }
    }

    public Object read(String keyString) {
        return this.read(this.getUrl(keyString));
    }

    public Object read(URL url) {
        if (!this.exists(url)) {
            return null;
        }
        Object object = null;
        try {
            FileContents fc = this.persistenceService.get(url);
            ObjectInputStream ois = new ObjectInputStream(fc.getInputStream());
            object = ois.readObject();
        }
        catch (Exception e) {
            System.out.println(this.getClass() + ".read(" + url + "): " + e);
        }
        return object;
    }

    public boolean exists(URL url) {
        try {
            if (this.persistenceService.getNames(url).length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println(this.getClass() + ".exists(" + url + "): " + e);
        }
        return false;
    }

    public void synchronize(String keyString) {
        this.synchronize(this.getUrl(keyString));
    }

    public void synchronize(URL url) {
        try {
            if (this.persistenceService.getTag(url) == 2) {
                this.persistenceService.setTag(url, 0);
            }
        }
        catch (Exception e) {
            System.out.println(this.getClass() + ".synchronize(" + url + "): " + e);
        }
    }

    public void removeEntry(URL url) {
        try {
            this.persistenceService.delete(url);
        }
        catch (Exception e) {
            System.out.println(this.getClass() + ".remove(" + url + "): " + e);
        }
    }

    public List getEntries(String keyString) {
        return this.getEntries(this.getUrl(keyString));
    }

    public List getEntries(URL url) {
        List<String> list = null;
        try {
            list = Collections.unmodifiableList(Arrays.asList(this.persistenceService.getNames(url)));
        }
        catch (Exception e) {
            System.out.println(this.getClass() + ".getEntries(" + url + "): " + e);
        }
        return list;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public URL getUrl(String keyString) {
        URL codebase = Utilities.getBasicService().getCodeBase();
        URL url = null;
        try {
            url = new URL(codebase, keyString);
        }
        catch (IOException ioe) {
            System.out.println(this.getClass() + ".getUrl(" + keyString + "): " + ioe);
        }
        return url;
    }
}

