/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzip {
    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static final void main(String[] args, boolean saveAll, List<String> include) {
        if (args.length != 1) {
            System.err.println("Usage: Unzip zipfile");
            return;
        }
        try {
            ZipFile zipFile = new ZipFile(args[0]);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File fAux = new File(entry.getName());
                File f = new File(fAux.getAbsolutePath());
                if (saveAll && entry.isDirectory()) {
                    System.err.println("Extracting directory: " + entry.getName());
                    f.mkdir();
                    continue;
                }
                if (!saveAll && !include.contains(entry.getName())) continue;
                System.err.println("Extracting file: " + entry.getName());
                Unzip.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(f)));
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            return;
        }
    }
}

