/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class RunnerThread
extends Thread {
    private Process p = null;
    private List<String> commandLine;
    private boolean isCmd;
    private String[] envp;
    private String path;

    public RunnerThread(List<String> commandLine, boolean isCmd, String[] envp, String path) {
        this.commandLine = commandLine;
        this.isCmd = isCmd;
        this.envp = envp;
        this.path = path;
    }

    @Override
    public void run() {
        try {
            System.out.println("Calling runner...");
            if (this.isCmd) {
                this.RunCmdCommand(this.commandLine, this.envp, this.path);
            } else {
                this.RunCommand(this.commandLine, this.envp, this.path);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void RunCmdCommand(List<String> cmd, String[] envp, String path) {
        ArrayList<String> fullCmd = new ArrayList<String>();
        if (OSValidator.isWindows()) {
            fullCmd.add("cmd");
            fullCmd.add("/c");
            String innerCommand = "";
            for (String s : cmd) {
                innerCommand = String.valueOf(innerCommand) + s + " ";
            }
            fullCmd.add(innerCommand);
            this.RunCommand(fullCmd, envp, path);
        } else if (OSValidator.isUnix() || OSValidator.isMac() || OSValidator.isSolaris()) {
            String innerCommand = "\"";
            for (String s : cmd) {
                innerCommand = String.valueOf(innerCommand) + s + " ";
            }
            innerCommand = String.valueOf(innerCommand) + "\" ";
            String[] command = new String[]{"sh", "-c", innerCommand};
            fullCmd.add(innerCommand);
            this.RunCommand(fullCmd, envp, path);
        }
    }

    public void RunCommand(List<String> fullCmd, String[] envp, String path) {
        try {
            ProcessBuilder b = new ProcessBuilder(fullCmd);
            b.directory(new File(path));
            b.inheritIO();
            Process p = b.start();
        }
        catch (IOException e) {
            System.err.println("Launching error.");
            e.printStackTrace();
        }
    }

    public ProcessResult RunCommand(String[] cmd, String[] envp, String path) {
        Object s = null;
        Object results = null;
        Runtime rt = Runtime.getRuntime();
        ProcessResult pr = null;
        try {
            Process p = rt.exec(cmd, envp, new File(path));
            pr = new ProcessResult();
            pr.setStdInput(new BufferedReader(new InputStreamReader(p.getInputStream())));
            pr.setStdInput(new BufferedReader(new InputStreamReader(p.getErrorStream())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pr;
    }
}

