/*
 * Decompiled with CFR 0.152.
 */
import com.marinilli.b2.c11.util.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.DownloadService;
import javax.jnlp.IntegrationService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;

public class Main {
    IntegrationService is = null;

    public void createShortcuts(String mecosimDir) {
        File installDir = new File(mecosimDir);
        if (OSValidator.isWindows() || OSValidator.isUnix() || OSValidator.isMac() || OSValidator.isSolaris()) {
            try {
                this.is = (IntegrationService)ServiceManager.lookup((String)"javax.jnlp.IntegrationService");
                if (this.is != null) {
                    boolean result;
                    boolean bl = result = this.is.hasMenuShortcut() || this.is.hasDesktopShortcut();
                    if (!result) {
                        boolean newShortcut = false;
                        if (OSValidator.isWindows() || !this.existsIcon()) {
                            System.out.println("Creating shortcuts...");
                            newShortcut = this.is.requestShortcut(true, true, null);
                        }
                        if (newShortcut) {
                            System.out.println("Shortcuts successfully created!");
                        }
                    }
                }
            }
            catch (UnavailableServiceException unavailableServiceException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void createDirs(String mecosimDir) {
        boolean created = false;
        File installDir = new File(mecosimDir);
        File bdDir = new File(String.valueOf(mecosimDir) + File.separator + "bd");
        if (!installDir.exists() || !bdDir.exists()) {
            System.out.println("Creating folder structure...");
            installDir.mkdir();
            String zipFile = "MeCoSim.zip";
            String zipFilePath = String.valueOf(mecosimDir) + "/" + zipFile;
            File zipF = this.copyToTarget(this, zipFile, zipFilePath);
            Unzip.main(new String[]{zipFilePath}, true, null);
            zipF.delete();
            created = true;
        } else {
            System.out.println("Replacing launcher...");
            installDir.mkdir();
            String zipFile = "MeCoSim.zip";
            String zipFilePath = String.valueOf(mecosimDir) + "/" + zipFile;
            File zipF = this.copyToTarget(this, zipFile, zipFilePath);
            ArrayList<String> mandatoryFiles = new ArrayList<String>();
            mandatoryFiles.add("Launcher.jar");
            mandatoryFiles.add("MeCoSim2.0.jar");
            mandatoryFiles.add("prop/ecosim-properties");
            Unzip.main(new String[]{zipFilePath}, false, mandatoryFiles);
            zipF.delete();
            created = true;
        }
    }

    private void runMeCoSim(String mecosimDir) {
        System.out.println("Running MeCoSim...");
        String launcherPath = "\"" + mecosimDir + "/Launcher.jar" + "\"";
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("java");
        commandLine.add("-jar");
        commandLine.add(launcherPath);
        String[] stringArray = new String[2];
        stringArray[1] = mecosimDir;
        InstallerExecutableRunner.runCmd(commandLine, stringArray);
    }

    public static void main(String[] args) {
        Main main = new Main();
        String home = System.getProperty("user.home");
        String mecosimDir = String.valueOf(home) + "/MeCoSim";
        System.setProperty("user.dir", mecosimDir);
        main.createShortcuts(mecosimDir);
        main.createDirs(mecosimDir);
        main.updateStructure(mecosimDir);
        main.runMeCoSim(mecosimDir);
        System.exit(0);
    }

    private void updateStructure(String mecosimDir) {
        URL url = null;
        try {
            DownloadService ds;
            String dependenciesDir;
            File dependenciesDirFile;
            String libDir;
            File libDirFile;
            File mecosimDirFile = new File(mecosimDir);
            if (!mecosimDirFile.exists()) {
                mecosimDirFile.mkdir();
            }
            if (!(libDirFile = new File(libDir = String.valueOf(mecosimDir) + File.separator + "lib")).exists()) {
                libDirFile.mkdir();
            }
            if (!(dependenciesDirFile = new File(dependenciesDir = String.valueOf(libDir) + File.separator + "MeCoSim2.0Core_lib")).exists()) {
                dependenciesDirFile.mkdir();
            }
            ArrayList<String> dependencies = new ArrayList<String>();
            int i = 1;
            String depName = "mydep" + i;
            String dep = System.getProperty(depName);
            while (dep != null) {
                dependencies.add(dep);
                depName = "mydep" + ++i;
                dep = System.getProperty(depName);
            }
            try {
                ds = (DownloadService)ServiceManager.lookup((String)"javax.jnlp.DownloadService");
            }
            catch (UnavailableServiceException use) {
                ds = null;
                System.out.println("Service is not supported: " + (Object)((Object)use));
            }
            boolean existNotCached = false;
            for (String myjar : dependencies) {
                URL origin = Utilities.getBasicService().getCodeBase();
                url = new URL(origin, myjar);
                boolean isCached = ds.isResourceCached(url, null);
                if (!existNotCached && !isCached) {
                    existNotCached = true;
                    Thread performer = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Please wait while installing modified packages...\nThis message will close automatically when the process finishes\nThen MeCoSim main window will be shown.\n", "Installing packages", 1);
                        }
                    });
                    performer.start();
                }
                String[] parts = myjar.split("__V");
                String path = String.valueOf(mecosimDir) + File.separator + parts[0] + ".jar";
                this.copyToTarget(url.openStream(), path);
            }
        }
        catch (IOException exc) {
            System.out.println("Creating URL: " + exc);
        }
    }

    private File copyToTarget(Object o, String fileName, String targetPath) {
        InputStream ist = o.getClass().getResourceAsStream(fileName);
        File zipF = new File(targetPath);
        try {
            this.copyFileToTargetPath(ist, zipF);
            ist.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zipF;
    }

    private void copyFileToTargetPath(InputStream ist, File zipF) throws FileNotFoundException, IOException {
        int len;
        FileOutputStream out = new FileOutputStream(zipF);
        byte[] buf = new byte[1024];
        while ((len = ist.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }

    private File copyToTarget(InputStream ist, String targetPath) {
        File zipF = new File(targetPath);
        try {
            this.copyFileToTargetPath(ist, zipF);
            ist.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zipF;
    }

    private boolean existsIcon() {
        boolean result = false;
        File desktop = new File(String.valueOf(System.getProperty("user.home")) + "/Desktop");
        File[] files = desktop.listFiles();
        if (files == null) {
            desktop = new File(String.valueOf(System.getProperty("user.home")) + "/Escritorio");
            files = desktop.listFiles();
        }
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean condition = false;
                if (OSValidator.isUnix() || OSValidator.isSolaris()) {
                    condition = file.getName().contains("jws_app_shortcut_");
                } else if (OSValidator.isMac()) {
                    String filename = file.getName();
                    boolean bl = condition = filename.endsWith(".app") && filename.toLowerCase().contains("mecosim");
                    if (condition) {
                        result = true;
                        break;
                    }
                }
                if (condition) {
                    try {
                        String sStr;
                        FileInputStream fis = new FileInputStream(file);
                        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                        while (!result && (sStr = br.readLine()) != null) {
                            if (!sStr.contains("MeCoSim")) continue;
                            result = true;
                        }
                        fis.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (result) break;
                ++n2;
            }
        }
        return result;
    }
}

